//+------------------------------------------------------------------+
//|                                           MACD(DEMA)DiNapoli.mq4 |
//|                           Copyright  2006, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  Silver
#property  indicator_color2  Red
//---- indicator parameters
extern double FastEMA=8.3896;
extern double SlowEMA=17.5185;
extern double SignalEMA=9.0503;
//---- indicator buffers
double     Macd_buffer[];
double     Sign_buffer[];
double     Fast_buffer[];
double     Slow_buffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   IndicatorBuffers(4);
   SetIndexBuffer(0,Macd_buffer);
   SetIndexBuffer(1,Sign_buffer);
   SetIndexBuffer(2,Fast_buffer);
   SetIndexBuffer(3,Slow_buffer);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexDrawBegin(0,1);
   SetIndexDrawBegin(1,1);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- indicator buffers mapping
   if(!SetIndexBuffer(0,Macd_buffer) && !SetIndexBuffer(1,Sign_buffer))
      Print("cannot set indicator buffers!");
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MACD(DEMA)DiNapoli("+FastEMA+","+SlowEMA+","+SignalEMA+")");
   SetIndexLabel(0,"MACD(DEMA)");
   SetIndexLabel(1,"Signal");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//|  MACD (DEMA) DiNapoli                                            |
//+------------------------------------------------------------------+
int start()
  {
   

   for(int i=Bars; i>=0; i--)
      {
      Fast_buffer[i]=0.0;
      Slow_buffer[i]=0.0;
      Macd_buffer[i]=0.0;
      Sign_buffer[i]=0.0;
      if (i==Bars) {Fast_buffer[i]=Close[i];Slow_buffer[i]=Close[i];} 
      }
//---- macd counted in the 1-st buffer      
   for( i=Bars-1; i>=0; i--)
      {
      Fast_buffer[i]=Fast_buffer[i+1]+2.0/(1.0+FastEMA)*(Close[i]-Fast_buffer[i+1]);
      Slow_buffer[i]=Slow_buffer[i+1]+2.0/(1.0+SlowEMA)*(Close[i]-Slow_buffer[i+1]);
      Macd_buffer[i]=Fast_buffer[i]-Slow_buffer[i];
      }
//---- signal line counted in the 2-nd buffer
   for(i=Bars-1; i>=0; i--)
      Sign_buffer[i]=Sign_buffer[i+1]+2.0/(1.0+SignalEMA)*(Macd_buffer[i]-Sign_buffer[i+1]);
//---- done
   return(0);
  }